<x-app-layout>
    <x-slot name="header">
        Blog
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.blog.create') }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Title</th>
                                    <th class="border-bottom-0">Category</th>
                                    <th class="border-bottom-0">Destination</th>
                                    <th class="border-bottom-0">Create Date</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($blogs as $blog)
                                <tr>
                                    <td>
                                        <a target="__blank" href="{{ route('front.blog', $blog->slug) }}">{{ word_limit($blog->title, 10) }}</a>
                                    </td>
                                    <td>{{ $blog->category->name }}</td>
                                    <td>{{ $blog->destination?->name??'Not Spesified' }}</td>
                                    <td>{{ $blog->created_at->format('D F, Y') }}</td>
                                    <td>
                                        @if ($blog->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.blog.edit', $blog->id) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route('admin.blog.destroy', $blog->id) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
